<?php
/**
 * XSLT for XML sitemap
 *
 * @module sitemaps
 */

$xsl = '<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
				xmlns:html="http://www.w3.org/TR/REC-html40"
				xmlns:sitemap="http://www.sitemaps.org/schemas/sitemap/0.9"
				xmlns:news="http://www.google.com/schemas/sitemap-news/0.9"
				xmlns:image="http://www.google.com/schemas/sitemap-image/1.1"
				xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" version="1.0" encoding="UTF-8" indent="yes"/>
	<xsl:template match="/">
		<html xmlns="http://www.w3.org/1999/xhtml">
			<head>
				<title>' . esc_html__( 'XML Sitemap', 'jetpack' ) . '</title>
				<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
				<style type="text/css">
					body {
						font: 14px "Open Sans", Helvetica, Arial, sans-serif;
						margin: 0;
					}

					a {
						color: #3498db;
						text-decoration: none;
					}

					h1 {
						margin: 0;
					}

					#description {
						background-color: #81a844;
						color: #FFF;
						padding: 30px 30px 20px;
					}

					#description a {
						color: #fff;
					}

					#content {
						padding: 10px 30px 30px;
						background: #fff;
					}

					a:hover {
						border-bottom: 1px solid;
					}

					th, td {
						font-size: 12px;
					}

					th {
						text-align: left;
						border-bottom: 1px solid #ccc;
					}

					th, td {
						padding: 10px 15px;
					}

					.odd {
						background-color: #E7F1D4;
					}

					#footer {
						margin: 20px 30px;
						font-size: 12px;
						color: #999;
					}

					#footer a {
						color: inherit;
					}

					#description a, #footer a {
						border-bottom: 1px solid;
					}
					#description a:hover, #footer a:hover {
						border-bottom: none;
					}
				</style>
			</head>
			<body>
				<div id="description">
					<h1>' . esc_html__( 'XML Sitemap', 'jetpack' ) . '</h1>
					<p>' . wp_kses( sprintf( __( 'This is an XML Sitemap generated by <a href="%s">Jetpack</a>, meant to be consumed by search engines like <a href="%s">Google</a> or <a href="%s">Bing</a>.', 'jetpack' ), 'http://jetpack.com/', 'https://www.google.com', 'https://www.bing.com/' ), array( 'a' => array( 'href' => true, 'title' => true ) ) ) . '</p>
					<p>' . wp_kses( sprintf( __( 'You can find more information on XML sitemaps at <a href="%s">sitemaps.org</a>', 'jetpack' ), 'http://sitemaps.org' ), array( 'a' => array( 'href' => true, 'title' => true ) ) ) . '</p>
				</div>
				<div id="content">
					<table>
						<tr>
							<th>' . esc_html__( 'URL', 'jetpack' ) . '</th>
							<th>' . esc_html__( 'Images', 'jetpack' ) . '</th>';
if ( empty( $type ) ) :
$xsl .= '					<th>' . esc_html__( 'Change Frequency', 'jetpack' ) . '</th>
							<th>' . esc_html__( 'Last Updated', 'jetpack' ) . '</th>';
endif;
$xsl .= '				</tr>
						<xsl:variable name="lower" select="\'abcdefghijklmnopqrstuvwxyz\'"/>
						<xsl:variable name="upper" select="\'ABCDEFGHIJKLMNOPQRSTUVWXYZ\'"/>
						<xsl:for-each select="sitemap:urlset/sitemap:url">
							<tr>
								<xsl:choose>
									<xsl:when test="position() mod 2 != 1">
										<xsl:attribute name="class">odd</xsl:attribute>
									</xsl:when>
								</xsl:choose>
								<td>
									<xsl:variable name="itemURL">
										<xsl:value-of select="sitemap:loc"/>
									</xsl:variable>
									<a href="{$itemURL}">
										<xsl:value-of select="sitemap:loc"/>
									</a>
								</td>
								<td>
									<xsl:value-of select="count(image:image)"/>
								</td>';
if ( empty( $type ) ) :
$xsl .= '						<td>
									<xsl:value-of select="concat(translate(substring(sitemap:changefreq, 1, 1),concat($lower, $upper),concat($upper, $lower)),substring(sitemap:changefreq, 2))"/>
								</td>
								<td>
									<xsl:value-of select="concat(substring(sitemap:lastmod,0,11),concat(\' \', substring(sitemap:lastmod,12,5)))"/>
								</td>';
endif;
$xsl .= '					</tr>
						</xsl:for-each>
					</table>
				</div>
				<div id="footer">
					<p>' . wp_kses( sprintf( __( '<em>Generated</em> by <a href="%s">Jetpack for WordPress</a>', 'jetpack' ), 'https://jetpack.com' ), array( 'a' => array( 'href' => true, 'title' => true ) ) ) . '</p>
				</div>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>';