(function ()
{
	// create zillaShortcodes plugin
	tinymce.create("tinymce.plugins.zillaShortcodes",
	{
		init: function ( ed, url )
		{
			ed.addCommand("zillaPopup", function ( a, params )
			{
				var popup = params.identifier;
				
				// load thickbox
				tb_show("Insert Zilla Shortcode", url + "/popup.php?popup=" + popup + "&width=" + 800);
			});
		},
		createControl: function ( btn, e )
		{
			if ( btn == "zilla_button" )
			{	
				var a = this;
				
				var btn = e.createSplitButton('zilla_button', {
                    title: "Insert Zilla Shortcode",
					image: ZillaShortcodes.plugin_folder +"/tinymce/images/icon.png",
					icons: false
                });

                btn.onRenderMenu.add(function (c, b)
				{					
					a.addWithPopup( b, "Columns", "columns" );
					a.addWithPopup( b, "Intro video background", "intro_video" );
					a.addWithPopup( b, "Fullscreen slider", "fullscreen_slider" );
					a.addWithPopup( b, "Fullscreen text slider", "fullscreen_text_slider" );
					a.addWithPopup( b, "Fullscreen image slider", "fullscreen_image_slider" );
					a.addWithPopup( b, "Accordion", "accordion" );
					a.addWithPopup( b, "Alerts", "alert" );
					a.addWithPopup( b, "News", "news" ); 
					a.addWithPopup( b, "Clients", "clients" );
					a.addWithPopup( b, "Content Box", "content_box" );
					a.addWithPopup( b, "Image Box", "image_box" );
					a.addWithPopup( b, "Contact Details", "contact_details" );
					a.addWithPopup( b, "Contact Form", "contact_form" ); 
					a.addWithPopup( b, "Google Map", "google_map" );
					a.addWithPopup( b, "Skills", "diagrams" );
					a.addWithPopup( b, "Divider", "divider" );
					a.addWithPopup( b, "Button", "button" );
					a.addWithPopup( b, "Number Details", "number_details" );
					a.addWithPopup( b, "Portfolio", "portfolio" );
					a.addWithPopup( b, "Portfolio gallery expand", "portfolio_gallery" );  
					a.addWithPopup( b, "Tabs", "tabs" );
					a.addWithPopup( b, "Team", "team" );
					a.addWithPopup( b, "Testimonial", "testimonial" );
					a.addWithPopup( b, "Service", "service" );
					a.addWithPopup( b, "Social Icons", "social_icon" );
					a.addWithPopup( b, "Pricing Tables", "pricing_tables" );
					a.addWithPopup( b, "Video", "video" );
				}); 
        return btn;
			}
			
			return null;
		},
		addWithPopup: function ( ed, title, id ) {
			ed.add({
				title: title,
				onclick: function () {
					tinyMCE.activeEditor.execCommand("zillaPopup", false, {
						title: title,
						identifier: id
					})
				}
			})
		},
		addImmediate: function ( ed, title, sc) {
			ed.add({
				title: title,
				onclick: function () {
					tinyMCE.activeEditor.execCommand( "mceInsertContent", false, sc )
				}
			})
		},
		getInfo: function () {
			return {
				longname: 'Zilla Shortcodes',
				author: 'Orman Clark',
				authorurl: 'http://themeforest.net/user/ormanclark/',
				infourl: 'http://wiki.moxiecode.com/',
				version: "1.0"
			}
		}
	});
	
	// add zillaShortcodes plugin
	tinymce.PluginManager.add("zillaShortcodes", tinymce.plugins.zillaShortcodes);
})();