# Strong Testimonials 
**Contributors:** cdillon27
  
**Donate link:** https://www.wpmission.com/donate/
  
**Tags:** testimonials, testimonial widget, random testimonial, testimonial shortcode, testimonial slider, testimonial form
  
**Requires at least:** 3.6
  
**Tested up to:** 4.5.3
  
**Stable tag:** trunk
  
**License:** GPLv3 or later
  
**License URI:** http://www.gnu.org/licenses/gpl-3.0.html
  

A full-featured testimonials plugin that works right out of the box for beginners and offers advanced features for pros, all backed by strong support.


## Description 

All the features you need to quickly add and customize testimonials on your site.

**[See demos of various templates, slideshows, and forms here!](http://demos.wpmission.com/strong-testimonials/)**


### Is this the right plugin for you? 
It's important to understand this plugin's intended use case: A small business with up to a few hundred testimonials, maybe organized into 5-10 categories, and displaying them a few different ways like a full page of testimonials and some slideshows, plus allowing customers to submit new testimonials.

If that describes your situation, this plugin will work for you right out of the box with just a few steps.


### Primary Features 

* A front-end form
* Categories
* Excerpts
* Featured Images (thumbnails)
* Slideshows with several navigation options
* Sort by oldest, newest, random, or menu order
* Simple pagination
* Built-in templates with several layout options
* Template files and functions for deep customization
* Custom "Read more" links
* Gravatar support
* Fully localized, ready for translations
* Compatible with [WPML](https://wpml.org/), [Polylang](https://wordpress.org/plugins/polylang/) and [WPGlobus](https://wordpress.org/plugins/wpglobus/)

Strong Testimonials [plays well with other plugins and themes](https://www.wpmission.com/theme-plugin-compatibility-fund/), and I strive to adhere to WordPress coding standards and best practices.


### The Form 

You can customize the form to your needs by adding or removing fields, or changing properties like the order, the text before or after, and the placeholder text.

The form also offers **anti-spam** options like honeypots and Captcha via these plugins: [Captcha](http://wordpress.org/plugins/captcha/), [Really Simple Captcha](http://wordpress.org/plugins/really-simple-captcha/), and [Advanced noCaptcha reCaptcha](https://wordpress.org/plugins/advanced-nocaptcha-recaptcha/).

**Notification emails** can be sent to multiple admins when new testimonials are submitted. New testimonials can also be assigned to a specific category.

The form can be submitted via Ajax which makes it compatible with the popular [Popup Maker](https://wordpress.org/plugins/popup-maker/) plugin.


### Display 

Everything happens in a **View**. Instead of learning multiple shortcodes with dozens of options, a View contains all the options in a simple, intuitive editor that no other testimonial plugin has. Display the View using a single shortcode or the widget.

Some of the options for displaying testimonials in a **list** or **slideshow**:

* select which testimonials to show
* set the sort order
* select which fields to include
* extras like pagination
* layout and style options

Check out the [screenshots](https://wordpress.org/plugins/strong-testimonials/screenshots/) to see the View editor.


### Style 

Strong Testimonials offers a handful of templates to try in your theme. The default template is just generic enough to look good in most cases with maybe a few tweaks.

Need help matching your theme? Got some weird spacing or floating? I'm here to help.

For ultimate control and seamless integration, any template can be copied to your theme and customized (a tutorial and more templates coming soon). There is also a template function that can display any View.


### Try these plugins too 

* [Simple Colorbox](https://wordpress.org/plugins/simple-colorbox/) to open thumbnails into full-size images. Nice!
* [Simple Custom CSS](https://wordpress.org/plugins/simple-custom-css/) for quick CSS tweaks.
* [Post State Tags](https://wordpress.org/plugins/post-state-tags/) helps quickly differentiate Published / Pending / Draft and more.
* [Wider Admin Menu](http://wordpress.org/plugins/wider-admin-menu/) lets your admin menu b r e a t h e.


### Translations 

* Arabic (ar_AR) - Ahmad Yousef
* French (fr_FR) - Jean-Paul Radet
* German (de_DE) - Richard Hopp
* Hebrew (he_IL) - Haim Asher
* Persian (fa_IR) - Mahmoud Zooroofchi
* Portuguese (pt_BR) - Mauricio Richieri
* Russian (ru_RU) - Матвеев Валерий
* Spanish (es_ES) - Diego Ferrández
* Swedish (sv_SE) - Tom Stone

Many, many thanks to these translators.

Did you know you can [translate phrases here](https://translate.wordpress.org/projects/wp-plugins/strong-testimonials)? Even just a few would help.

[Contact me](https://www.wpmission.com/contact/) to contribute a full translation.


## Installation 

1. Go to Plugins > Add New.
1. Search for "strong testimonials".
1. Click "Install Now".

OR

1. Download the zip file.
1. Upload the zip file via Plugins > Add New > Upload.

Finally, activate the plugin.


## Frequently Asked Questions 


### Can I change the fields on the form? 

Yes. There is a custom field editor where you can add or remove fields, change field details, and drag-and-drop to reorder them. You can also customize the form error & success messages and the Submit button.


### I want to use categories. Can I add a category selector to the submission form? 

Yes. After setting up your categories, you can add a category dropdown element to the form.


### Can I edit the notification email that goes out when a new testimonial has been submitted? 

Yes. You can completely customize the email and send it to multiple recipients, or turn it off altogether.


### Can I change which client fields appear below the testimonial? 

Yes. In Views, these custom fields can be changed with a few clicks.


### Can I change "testimonial" to "review", for example? 

Maybe. Instructions are [here](https://wordpress.org/support/topic/how-to-change-the-slug). However, this does not seem to work for all theme/plugin combinations so I plan to build this into the plugin soon.


### My theme also includes testimonials. Will that be a problem? 

It depends. I have narrowed down the causes of many conflicts and addressed them in the plugin. If you encounter trouble, use the support form or contact me and we'll sort it out. If you want help disabling testimonials in your theme, even better :)


### I'm familiar with template files. Can I customize the template? 

Yes. With some HTML and CSS knowledge, you can copy any template to your theme and customize it as you see fit. You can also have multiple custom templates. A [tutorial](https://www.wpmission.com/knowledge-base/strong-testimonials/) is coming soon.


## Screenshots 

1. The default View settings and the default template.
2. Another View and the Simple template.
3. The form with default fields plus Captcha.
4. The testimonial admin list.
5. The testimonial form settings.
6. The View editor.
7. The custom fields editor.
8. Template files and template functions.


## Changelog 

### 2.11.3 - July 25, 2016
* Remove background on Modern template.

### 2.11.2 - July 20, 2016
* New template: Modern.

### 2.11.1 - July 20, 2016
* Fix bug in pagination.
* Fix bug in View class name option.

### 2.11 - July 19, 2016
* Slideshow navigation options.

### 2.10.3 - July 13, 2016
* Fix conflict with NextGEN Gallery.
* Fix bugs in update process.
* Add `wpmtst_before_testimonial` and `wpmtst_after_testimonial` hooks for prepending and appending content to each testimonial.

### 2.10.2 - July 12, 2016
* Fix bug in "Read more" selector.

### 2.10.1 - July 11, 2016
* Fix bug in single testimonial selector.

### 2.10 - July 11, 2016
* Fix bug when not using company_website field.
* Improve "Read more" link to behave like standard blog posts.
* Separate option for a "Read more" link to a page/post.
* Option to show an indicator bubble for pending testimonials.
* Include Font Awesome instead of loading via CDN.

### 2.9.4 - July 2, 2016
* Compatible with FooBox Image Lightbox [Free](https://wordpress.org/plugins/foobox-image-lightbox/) and [Pro](http://fooplugins.com/plugins/foobox/) versions.

### 2.9.3 - June 28, 2016
* Fix conflict with themes and plugins that also include Font Awesome.

### 2.9.2 - June 28, 2016
* Fix bug.

### 2.9.1 - June 28, 2016
* Fix conflict with WooCommerce.

### 2.9 - June 3, 2016 
* Compatible with [Max Mega Menu](https://wordpress.org/plugins/megamenu/) plugin.
* Disable redirect to Guide page after update.
* Disable console log output in Cycle script.

### 2.8.1 - June 1, 2016 
* Fix bug: "Array" in client fields output.

### 2.8 - May 31, 2016 
* Add option for notification mail queue.
* Updated Spanish translation.

### 2.7.1 - May 20, 2016 
* Fix grid height and margins.

### 2.7 - May 19, 2016 
* Add option for slideshow z-index to improve compatibility.
* Fix bug in gradient background setting.
* Improve Client Details meta box style.
* Ensure custom template plugin paths are found.
* Fix improper enqueue of Dashicons.
* Latest FontAwesome.

### 2.6.1 - May 18, 2016 
* Update the Guide.
* Improve responsive style.

### 2.6 - May 17, 2016 
* Bypass WordPress empty post check.
* Enable embeds (YouTube, Twitter, etc.).
* Add setting for embed frame width.
